/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.ColumnValueSelector;

public class DoublesSketchMergeAggregator
implements Aggregator {
    private final ColumnValueSelector<DoublesSketch> selector;
    private DoublesUnion union;

    public DoublesSketchMergeAggregator(ColumnValueSelector<DoublesSketch> selector, int k) {
        this.selector = selector;
        this.union = DoublesUnion.builder().setMaxK(k).build();
    }

    public synchronized void aggregate() {
        DoublesSketch sketch = (DoublesSketch)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        this.union.update(sketch);
    }

    public synchronized Object get() {
        return this.union.getResult();
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized void close() {
        this.union = null;
    }
}

