/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import com.yahoo.sketches.quantiles.DoublesUnionBuilder;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;

public class DoublesSketchMergeBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<DoublesSketch> selector;
    private final int k;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<DoublesUnion>> unions = new IdentityHashMap();

    public DoublesSketchMergeBufferAggregator(ColumnValueSelector<DoublesSketch> selector, int k, int maxIntermediateSize) {
        this.selector = selector;
        this.k = k;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public synchronized void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        DoublesUnion union = DoublesUnion.builder().setMaxK(this.k).build(region);
        this.putUnion(buffer, position, union);
    }

    public synchronized void aggregate(ByteBuffer buffer, int position) {
        DoublesSketch sketch = (DoublesSketch)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        DoublesUnion union = (DoublesUnion)this.unions.get(buffer).get(position);
        union.update(sketch);
    }

    public synchronized Object get(ByteBuffer buffer, int position) {
        return ((DoublesUnion)this.unions.get(buffer).get(position)).getResult();
    }

    public float getFloat(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized void close() {
        this.unions.clear();
        this.memCache.clear();
    }

    public synchronized void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldMem;
        DoublesUnion union = (DoublesUnion)this.unions.get(oldBuffer).get(oldPosition);
        if (union.isSameResource((Memory)(oldMem = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newMem = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            union = DoublesUnionBuilder.wrap((WritableMemory)newMem);
        }
        this.putUnion(newBuffer, newPosition, union);
        Int2ObjectMap<DoublesUnion> map = this.unions.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.unions.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.wrap((ByteBuffer)buf));
    }

    private void putUnion(ByteBuffer buffer, int position, DoublesUnion union) {
        Int2ObjectMap map = this.unions.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)union);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

