/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.yahoo.sketches.quantiles.DoublesSketch;
import io.druid.java.util.common.Cacheable;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class DoublesSketchToHistogramPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final double[] splitPoints;

    @JsonCreator
    public DoublesSketchToHistogramPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="splitPoints") double[] splitPoints) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.splitPoints = (double[])Preconditions.checkNotNull((Object)splitPoints, (Object)"array of split points is null");
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        DoublesSketch sketch = (DoublesSketch)this.field.compute(combinedAggregators);
        double[] histogram = sketch.getPMF(this.splitPoints);
        int i = 0;
        while (i < histogram.length) {
            int n = i++;
            histogram[n] = histogram[n] * (double)sketch.getN();
        }
        return histogram;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public double[] getSplitPoints() {
        return this.splitPoints;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing histograms is not supported", new Object[0]);
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + ", splitPoints=" + Arrays.toString(this.splitPoints) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoublesSketchToHistogramPostAggregator that = (DoublesSketchToHistogramPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.splitPoints, that.splitPoints)) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() * 31 + this.field.hashCode();
        hashCode = hashCode * 31 + Arrays.hashCode(this.splitPoints);
        return hashCode;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(29).appendCacheable((Cacheable)this.field);
        for (double value : this.splitPoints) {
            builder.appendDouble(value);
        }
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

