/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.yahoo.sketches.quantiles.DoublesSketch;
import io.druid.java.util.common.Cacheable;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class DoublesSketchToQuantilePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final double fraction;

    @JsonCreator
    public DoublesSketchToQuantilePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="fraction") double fraction) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.fraction = fraction;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public double getFraction() {
        return this.fraction;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        DoublesSketch sketch = (DoublesSketch)this.field.compute(combinedAggregators);
        return sketch.getQuantile(this.fraction);
    }

    public Comparator<Double> getComparator() {
        return new Comparator<Double>(){

            @Override
            public int compare(Double a, Double b) {
                return Doubles.compare((double)a, (double)b);
            }
        };
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + ", fraction=" + this.fraction + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoublesSketchToQuantilePostAggregator that = (DoublesSketchToQuantilePostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.fraction != that.fraction) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + this.field.hashCode()) * 31 + Double.hashCode(this.fraction);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(30).appendCacheable((Cacheable)this.field).appendDouble(this.fraction).build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

