/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.yahoo.sketches.quantiles.DoublesSketch;
import io.druid.java.util.common.Cacheable;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class DoublesSketchToStringPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;

    @JsonCreator
    public DoublesSketchToStringPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        DoublesSketch sketch = (DoublesSketch)this.field.compute(combinedAggregators);
        return sketch.toString();
    }

    public Comparator<String> getComparator() {
        throw new IAE("Comparing sketch summaries is not supported", new Object[0]);
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoublesSketchToStringPostAggregator that = (DoublesSketchToStringPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + this.field.hashCode()) * 31;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(32).appendCacheable((Cacheable)this.field);
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

