/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Union;
import io.druid.java.util.common.ISE;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.datasketches.theta.SketchHolder;
import io.druid.query.aggregation.datasketches.theta.SynchronizedUnion;
import io.druid.segment.BaseObjectColumnValueSelector;
import java.util.List;

public class SketchAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector selector;
    private final int size;
    private Union union;

    public SketchAggregator(BaseObjectColumnValueSelector selector, int size) {
        this.selector = selector;
        this.size = size;
    }

    private void initUnion() {
        this.union = new SynchronizedUnion((Union)SetOperation.builder().setNominalEntries(this.size).build(Family.UNION));
    }

    public void aggregate() {
        Object update = this.selector.getObject();
        if (update == null) {
            return;
        }
        if (this.union == null) {
            this.initUnion();
        }
        SketchAggregator.updateUnion(this.union, update);
    }

    public Object get() {
        if (this.union == null) {
            return SketchHolder.EMPTY;
        }
        return SketchHolder.of(this.union.getResult(true, null));
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.union = null;
    }

    static void updateUnion(Union union, Object update) {
        if (update instanceof SketchHolder) {
            ((SketchHolder)update).updateUnion(union);
        } else if (update instanceof String) {
            union.update((String)update);
        } else if (update instanceof byte[]) {
            union.update((byte[])update);
        } else if (update instanceof Double) {
            union.update(((Double)update).doubleValue());
        } else if (update instanceof Integer || update instanceof Long) {
            union.update(((Number)update).longValue());
        } else if (update instanceof int[]) {
            union.update((int[])update);
        } else if (update instanceof long[]) {
            union.update((long[])update);
        } else if (update instanceof List) {
            for (Object entry : (List)update) {
                union.update(entry.toString());
            }
        } else {
            throw new ISE("Illegal type received while theta sketch merging [%s]", new Object[]{update.getClass()});
        }
    }
}

