/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Union;
import io.druid.java.util.common.StringUtils;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.ObjectAggregateCombiner;
import io.druid.query.aggregation.datasketches.theta.SketchAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchBufferAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchHolder;
import io.druid.segment.BaseObjectColumnValueSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class SketchAggregatorFactory
extends AggregatorFactory {
    public static final int DEFAULT_MAX_SKETCH_SIZE = 16384;
    protected final String name;
    protected final String fieldName;
    protected final int size;
    private final byte cacheId;

    public SketchAggregatorFactory(String name, String fieldName, Integer size, byte cacheId) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.size = size == null ? 16384 : size;
        Util.checkIfPowerOf2((int)this.size, (String)"size");
        this.cacheId = cacheId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        return new SketchAggregator((BaseObjectColumnValueSelector)selector, this.size);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        return new SketchBufferAggregator((BaseObjectColumnValueSelector)selector, this.size, this.getMaxIntermediateSize());
    }

    public Object deserialize(Object object) {
        return SketchHolder.deserialize(object);
    }

    public Comparator<Object> getComparator() {
        return SketchHolder.COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        return SketchHolder.combine(lhs, rhs, this.size);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<SketchHolder>(){
            private final Union union;
            private final SketchHolder combined;
            {
                this.union = (Union)SetOperation.builder().setNominalEntries(SketchAggregatorFactory.this.size).build(Family.UNION);
                this.combined = SketchHolder.of(this.union);
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                SketchHolder other = (SketchHolder)selector.getObject();
                if (other != null) {
                    other.updateUnion(this.union);
                    this.combined.invalidateCache();
                }
            }

            public Class<SketchHolder> classOfObject() {
                return SketchHolder.class;
            }

            @Nullable
            public SketchHolder getObject() {
                return this.combined;
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getSize() {
        return this.size;
    }

    public int getMaxIntermediateSize() {
        return SetOperation.getMaxUnionBytes((int)this.size);
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(5 + fieldNameBytes.length).put(this.cacheId).putInt(this.size).put(fieldNameBytes).array();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SketchAggregatorFactory that = (SketchAggregatorFactory)((Object)o);
        if (this.size != that.size) {
            return false;
        }
        if (this.cacheId != that.cacheId) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.cacheId;
        return result;
    }
}

