/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import io.druid.java.util.common.Cacheable;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchEstimateWithErrorBounds;
import io.druid.query.aggregation.datasketches.theta.SketchHolder;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SketchEstimatePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final Integer errorBoundsStdDev;

    @JsonCreator
    public SketchEstimatePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="errorBoundsStdDev") Integer errorBoundsStdDev) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.errorBoundsStdDev = errorBoundsStdDev;
    }

    public Set<String> getDependentFields() {
        HashSet dependentFields = Sets.newHashSet();
        dependentFields.addAll(this.field.getDependentFields());
        return dependentFields;
    }

    public Comparator getComparator() {
        if (this.errorBoundsStdDev == null) {
            return Ordering.natural();
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Doubles.compare((double)((SketchEstimateWithErrorBounds)o1).getEstimate(), (double)((SketchEstimateWithErrorBounds)o2).getEstimate());
            }
        };
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        SketchHolder holder = (SketchHolder)this.field.compute(combinedAggregators);
        if (this.errorBoundsStdDev != null) {
            return holder.getEstimateWithErrorBounds(this.errorBoundsStdDev);
        }
        return holder.getEstimate();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public Integer getErrorBoundsStdDev() {
        return this.errorBoundsStdDev;
    }

    public String toString() {
        return "SketchEstimatePostAggregator{name='" + this.name + '\'' + ", field=" + this.field + ", errorBoundsStdDev=" + this.errorBoundsStdDev + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchEstimatePostAggregator that = (SketchEstimatePostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.errorBoundsStdDev == null ^ that.errorBoundsStdDev == null) {
            return false;
        }
        if (this.errorBoundsStdDev != null && that.errorBoundsStdDev != null && this.errorBoundsStdDev.intValue() != that.errorBoundsStdDev.intValue()) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + (this.errorBoundsStdDev != null ? this.errorBoundsStdDev.hashCode() : 0);
        return result;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(17).appendCacheable((Cacheable)this.field);
        return this.errorBoundsStdDev == null ? builder.build() : builder.appendInt(this.errorBoundsStdDev.intValue()).build();
    }
}

