/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Supplier;
import com.yahoo.sketches.theta.Sketch;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.query.aggregation.datasketches.theta.SketchHolder;
import io.druid.query.aggregation.datasketches.theta.SketchObjectStrategy;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.nio.ByteBuffer;

public class SketchMergeComplexMetricSerde
extends ComplexMetricSerde {
    private SketchObjectStrategy strategy = new SketchObjectStrategy();

    public String getTypeName() {
        return "thetaSketch";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<?> extractedClass() {
                return Object.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object == null) {
                    return object;
                }
                return SketchHolder.deserialize(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed ge = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)this.strategy, (SmooshedFileMapper)builder.getFileMapper());
        builder.setComplexColumn((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), ge));
    }

    public ObjectStrategy<Sketch> getObjectStrategy() {
        return this.strategy;
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }
}

