/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.theta.Sketch;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.datasketches.theta.SketchHolder;
import io.druid.segment.data.ObjectStrategy;
import java.nio.ByteBuffer;

public class SketchObjectStrategy
implements ObjectStrategy {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public int compare(Object s1, Object s2) {
        return SketchHolder.COMPARATOR.compare(s1, s2);
    }

    public Class<?> getClazz() {
        return Object.class;
    }

    public Object fromByteBuffer(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return SketchHolder.EMPTY;
        }
        return SketchHolder.of(Memory.wrap((ByteBuffer)buffer).region((long)buffer.position(), (long)numBytes));
    }

    public byte[] toBytes(Object obj) {
        if (obj instanceof SketchHolder) {
            Sketch sketch = ((SketchHolder)obj).getSketch();
            if (sketch.isEmpty()) {
                return EMPTY_BYTES;
            }
            return sketch.toByteArray();
        }
        if (obj == null) {
            return EMPTY_BYTES;
        }
        throw new IAE("Unknown class[%s], toString[%s]", new Object[]{obj.getClass(), obj});
    }
}

