/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Union;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.datasketches.theta.SynchronizedUnion;
import io.druid.segment.ObjectColumnSelector;
import java.util.List;

public class SketchAggregator
implements Aggregator {
    private static final Logger logger = new Logger(SketchAggregator.class);
    private final ObjectColumnSelector selector;
    private final String name;
    private final int size;
    private Union union;

    public SketchAggregator(String name, ObjectColumnSelector selector, int size) {
        this.name = name;
        this.selector = selector;
        this.size = size;
        this.union = new SynchronizedUnion((Union)SetOperation.builder().build(size, Family.UNION));
    }

    public void aggregate() {
        Object update = this.selector.get();
        if (update == null) {
            return;
        }
        SketchAggregator.updateUnion(this.union, update);
    }

    public void reset() {
        this.union.reset();
    }

    public Object get() {
        return this.union.getResult(true, null);
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getName() {
        return this.name;
    }

    public void close() {
        this.union = null;
    }

    static void updateUnion(Union union, Object update) {
        if (update instanceof Memory) {
            union.update((Memory)update);
        } else if (update instanceof Sketch) {
            union.update((Sketch)update);
        } else if (update instanceof Union) {
            union.update((Sketch)((Union)update).getResult(false, null));
        } else if (update instanceof String) {
            union.update((String)update);
        } else if (update instanceof byte[]) {
            union.update((byte[])update);
        } else if (update instanceof Double) {
            union.update(((Double)update).doubleValue());
        } else if (update instanceof Integer || update instanceof Long) {
            union.update(((Number)update).longValue());
        } else if (update instanceof int[]) {
            union.update((int[])update);
        } else if (update instanceof long[]) {
            union.update((long[])update);
        } else if (update instanceof List) {
            for (Object entry : (List)update) {
                union.update(entry.toString());
            }
        } else {
            throw new ISE("Illegal type received while theta sketch merging [%s]", new Object[]{update.getClass()});
        }
    }
}

