/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import com.metamx.common.IAE;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Sketches;
import com.yahoo.sketches.theta.Union;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.datasketches.theta.EmptySketchAggregator;
import io.druid.query.aggregation.datasketches.theta.EmptySketchBufferAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchBufferAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchOperations;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class SketchAggregatorFactory
extends AggregatorFactory {
    public static final int DEFAULT_MAX_SKETCH_SIZE = 16384;
    protected final String name;
    protected final String fieldName;
    protected final int size;
    private final byte cacheId;
    public static final Comparator<Object> COMPARATOR = Ordering.from((Comparator)new Comparator(){

        public int compare(Object o1, Object o2) {
            Sketch s1 = SketchAggregatorFactory.toSketch(o1);
            Sketch s2 = SketchAggregatorFactory.toSketch(o2);
            return Doubles.compare((double)s1.getEstimate(), (double)s2.getEstimate());
        }
    }).nullsFirst();

    public SketchAggregatorFactory(String name, String fieldName, Integer size, byte cacheId) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.size = size == null ? 16384 : size;
        Util.checkIfPowerOf2((int)this.size, (String)"size");
        this.cacheId = cacheId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            return new EmptySketchAggregator(this.name);
        }
        return new SketchAggregator(this.name, selector, this.size);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            return new EmptySketchBufferAggregator();
        }
        return new SketchBufferAggregator(selector, this.size, this.getMaxIntermediateSize());
    }

    public Object deserialize(Object object) {
        return SketchOperations.deserialize(object);
    }

    public Comparator<Object> getComparator() {
        return COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        Union union;
        if (lhs instanceof Union) {
            union = (Union)lhs;
            this.updateUnion(union, rhs);
        } else if (rhs instanceof Union) {
            union = (Union)rhs;
            this.updateUnion(union, lhs);
        } else {
            union = (Union)SetOperation.builder().build(this.size, Family.UNION);
            this.updateUnion(union, lhs);
            this.updateUnion(union, rhs);
        }
        return union;
    }

    private void updateUnion(Union union, Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Memory) {
            union.update((Memory)obj);
        } else if (obj instanceof Sketch) {
            union.update((Sketch)obj);
        } else if (obj instanceof Union) {
            union.update((Sketch)((Union)obj).getResult(false, null));
        } else {
            throw new IAE("Object of type [%s] can not be unioned", new Object[]{obj.getClass().getName()});
        }
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getSize() {
        return this.size;
    }

    public int getMaxIntermediateSize() {
        return SetOperation.getMaxUnionBytes((int)this.size);
    }

    public Object getAggregatorStartValue() {
        return Sketches.updateSketchBuilder().build(this.size);
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = this.fieldName.getBytes();
        return ByteBuffer.allocate(5 + fieldNameBytes.length).put(this.cacheId).putInt(this.size).put(fieldNameBytes).array();
    }

    public static final Sketch toSketch(Object obj) {
        if (obj instanceof Sketch) {
            return (Sketch)obj;
        }
        if (obj instanceof Union) {
            return ((Union)obj).getResult(true, null);
        }
        throw new IAE("Can't convert to Sketch object [%s]", new Object[]{obj.getClass()});
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SketchAggregatorFactory that = (SketchAggregatorFactory)((Object)o);
        if (this.size != that.size) {
            return false;
        }
        if (this.cacheId != that.cacheId) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.cacheId;
        return result;
    }
}

