/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRegion;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Sketches;
import com.yahoo.sketches.theta.Union;
import io.druid.query.aggregation.datasketches.theta.SketchAggregatorFactory;
import io.druid.segment.data.ObjectStrategy;
import java.nio.ByteBuffer;

public class SketchObjectStrategy
implements ObjectStrategy {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Sketch EMPTY_SKETCH = Sketches.updateSketchBuilder().build().compact(true, null);

    public int compare(Object s1, Object s2) {
        if (s1 instanceof Sketch || s1 instanceof Union) {
            if (s2 instanceof Sketch || s2 instanceof Union) {
                return SketchAggregatorFactory.COMPARATOR.compare(s1, s2);
            }
            return -1;
        }
        if (s1 instanceof Memory) {
            if (s2 instanceof Memory) {
                Memory s1Mem = (Memory)s1;
                Memory s2Mem = (Memory)s2;
                int retVal = Longs.compare((long)s1Mem.getCapacity(), (long)s2Mem.getCapacity());
                if (retVal == 0) {
                    retVal = Longs.compare((long)s1Mem.getLong(s1Mem.getCapacity() - 8L), (long)s2Mem.getLong(s2Mem.getCapacity() - 8L));
                }
                return retVal;
            }
            return 1;
        }
        throw new IAE("Unknwon class[%s], toString[%s]", new Object[]{s1.getClass(), s1});
    }

    public Class<? extends Sketch> getClazz() {
        return Sketch.class;
    }

    public Object fromByteBuffer(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return EMPTY_SKETCH;
        }
        return new MemoryRegion((Memory)new NativeMemory(buffer), (long)buffer.position(), (long)numBytes);
    }

    public byte[] toBytes(Object obj) {
        if (obj instanceof Sketch) {
            Sketch sketch = (Sketch)obj;
            if (sketch.isEmpty()) {
                return EMPTY_BYTES;
            }
            return sketch.toByteArray();
        }
        if (obj instanceof Memory) {
            Memory mem = (Memory)obj;
            byte[] retVal = new byte[(int)mem.getCapacity()];
            mem.getByteArray(0L, retVal, 0, (int)mem.getCapacity());
            return retVal;
        }
        if (obj instanceof Union) {
            return this.toBytes(((Union)obj).getResult(true, null));
        }
        if (obj == null) {
            return EMPTY_BYTES;
        }
        throw new IAE("Unknown class[%s], toString[%s]", new Object[]{obj.getClass(), obj});
    }
}

