/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Charsets;
import com.metamx.common.logger.Logger;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.AnotB;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Sketches;
import com.yahoo.sketches.theta.Union;
import org.apache.commons.codec.binary.Base64;

public class SketchOperations {
    private static final Logger LOG = new Logger(SketchOperations.class);
    public static final Sketch EMPTY_SKETCH = Sketches.updateSketchBuilder().build().compact(true, null);

    public static Sketch deserialize(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return SketchOperations.deserializeFromBase64EncodedString((String)serializedSketch);
        }
        if (serializedSketch instanceof byte[]) {
            return SketchOperations.deserializeFromByteArray((byte[])serializedSketch);
        }
        if (serializedSketch instanceof Sketch) {
            return (Sketch)serializedSketch;
        }
        if (serializedSketch instanceof Union) {
            return ((Union)serializedSketch).getResult(true, null);
        }
        throw new IllegalStateException("Object is not of a type that can deserialize to sketch: " + serializedSketch.getClass());
    }

    public static Sketch deserializeFromBase64EncodedString(String str) {
        return SketchOperations.deserializeFromByteArray(Base64.decodeBase64((byte[])str.getBytes(Charsets.UTF_8)));
    }

    public static Sketch deserializeFromByteArray(byte[] data) {
        return SketchOperations.deserializeFromMemory((Memory)new NativeMemory(data));
    }

    public static Sketch deserializeFromMemory(Memory mem) {
        if (Sketch.getSerializationVersion((Memory)mem) < 3) {
            return Sketches.heapifySketch((Memory)mem);
        }
        return Sketches.wrapSketch((Memory)mem);
    }

    public static Sketch sketchSetOperation(Func func, int sketchSize, Sketch ... sketches) {
        switch (func) {
            case UNION: {
                Union union = (Union)SetOperation.builder().build(sketchSize, Family.UNION);
                for (Sketch sketch : sketches) {
                    union.update(sketch);
                }
                return union.getResult(false, null);
            }
            case INTERSECT: {
                Intersection intersection = (Intersection)SetOperation.builder().build(sketchSize, Family.INTERSECTION);
                for (Sketch sketch : sketches) {
                    intersection.update(sketch);
                }
                return intersection.getResult(false, null);
            }
            case NOT: {
                if (sketches.length < 1) {
                    throw new IllegalArgumentException("A-Not-B requires atleast 1 sketch");
                }
                if (sketches.length == 1) {
                    return sketches[0];
                }
                Sketch result = sketches[0];
                for (int i = 1; i < sketches.length; ++i) {
                    AnotB anotb = (AnotB)SetOperation.builder().build(sketchSize, Family.A_NOT_B);
                    anotb.update(result, sketches[i]);
                    result = anotb.getResult(false, null);
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown sketch operation " + (Object)((Object)func));
    }

    public static enum Func {
        UNION,
        INTERSECT,
        NOT;

    }
}

