/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.Sketch;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchAggregatorFactory;
import io.druid.query.aggregation.datasketches.theta.SketchOperations;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SketchSetPostAggregator
implements PostAggregator {
    private static final Logger LOG = new Logger(SketchSetPostAggregator.class);
    private final String name;
    private final List<PostAggregator> fields;
    private final SketchOperations.Func func;
    private final int maxSketchSize;

    @JsonCreator
    public SketchSetPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="func") String func, @JsonProperty(value="size") Integer maxSize, @JsonProperty(value="fields") List<PostAggregator> fields) {
        this.name = name;
        this.fields = fields;
        this.func = SketchOperations.Func.valueOf(func);
        this.maxSketchSize = maxSize == null ? 16384 : maxSize;
        Util.checkIfPowerOf2((int)this.maxSketchSize, (String)"size");
        if (fields.size() <= 1) {
            throw new IAE("Illegal number of fields[%s], must be > 1", new Object[]{fields.size()});
        }
    }

    public Set<String> getDependentFields() {
        LinkedHashSet dependentFields = Sets.newLinkedHashSet();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    public Comparator<Object> getComparator() {
        return SketchAggregatorFactory.COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        Sketch[] sketches = new Sketch[this.fields.size()];
        for (int i = 0; i < sketches.length; ++i) {
            sketches[i] = SketchAggregatorFactory.toSketch(this.fields.get(i).compute(combinedAggregators));
        }
        return SketchOperations.sketchSetOperation(this.func, this.maxSketchSize, sketches);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFunc() {
        return this.func.toString();
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    @JsonProperty
    public int getSize() {
        return this.maxSketchSize;
    }

    public String toString() {
        return "SketchSetPostAggregator{name='" + this.name + '\'' + ", fields=" + this.fields + ", func=" + (Object)((Object)this.func) + ", size=" + this.maxSketchSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchSetPostAggregator that = (SketchSetPostAggregator)o;
        if (this.maxSketchSize != that.maxSketchSize) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return this.func == that.func;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.func.hashCode();
        result = 31 * result + this.maxSketchSize;
        return result;
    }
}

