/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.common.logger.Logger;
import io.druid.storage.hdfs.HdfsKerberosConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

@ManageLifecycle
public class HdfsStorageAuthentication {
    private static final Logger log = new Logger(HdfsStorageAuthentication.class);
    private final HdfsKerberosConfig hdfsKerberosConfig;
    private final Configuration hadoopConf;

    @Inject
    public HdfsStorageAuthentication(HdfsKerberosConfig hdfsKerberosConfig, Configuration hadoopConf) {
        this.hdfsKerberosConfig = hdfsKerberosConfig;
        this.hadoopConf = hadoopConf;
    }

    @LifecycleStart
    public void authenticate() {
        String principal = this.hdfsKerberosConfig.getPrincipal();
        String keytab = this.hdfsKerberosConfig.getKeytab();
        if (!Strings.isNullOrEmpty((String)principal) && !Strings.isNullOrEmpty((String)keytab)) {
            UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(principal)) {
                        log.info("Trying to authenticate user [%s] with keytab [%s]..", new Object[]{principal, keytab});
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                }
                catch (IOException e) {
                    throw new ISE((Throwable)e, "Failed to authenticate user principal [%s] with keytab [%s]", new Object[]{principal, keytab});
                }
            }
        }
    }

    @LifecycleStop
    public void stop() {
    }
}

