/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentFinder;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HdfsDataSegmentFinder
implements DataSegmentFinder {
    private static final Logger log = new Logger(HdfsDataSegmentFinder.class);
    private final Configuration config;
    private final ObjectMapper mapper;

    @Inject
    public HdfsDataSegmentFinder(Configuration config, ObjectMapper mapper) {
        this.config = config;
        this.mapper = mapper;
    }

    public Set<DataSegment> findSegments(String workingDirPathStr, boolean updateDescriptor) throws SegmentLoadingException {
        HashSet segments = Sets.newHashSet();
        Path workingDirPath = new Path(workingDirPathStr);
        try {
            FileSystem fs = workingDirPath.getFileSystem(this.config);
            log.info(fs.getScheme(), new Object[0]);
            log.info("FileSystem URI:" + fs.getUri().toString(), new Object[0]);
            if (!fs.exists(workingDirPath)) {
                throw new SegmentLoadingException("Working directory [%s] doesn't exist.", new Object[]{workingDirPath});
            }
            if (!fs.isDirectory(workingDirPath)) {
                throw new SegmentLoadingException("Working directory [%s] is not a directory!?", new Object[]{workingDirPath});
            }
            RemoteIterator it = fs.listFiles(workingDirPath, true);
            while (it.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)it.next();
                Path path = locatedFileStatus.getPath();
                if (!path.getName().equals("descriptor.json")) continue;
                Path indexZip = new Path(path.getParent(), "index.zip");
                if (fs.exists(indexZip)) {
                    DataSegment dataSegment = (DataSegment)this.mapper.readValue((InputStream)fs.open(path), DataSegment.class);
                    log.info("Found segment [%s] located at [%s]", new Object[]{dataSegment.getIdentifier(), indexZip});
                    Map loadSpec = dataSegment.getLoadSpec();
                    String pathWithoutScheme = indexZip.toUri().getPath();
                    if (!loadSpec.get("type").equals("hdfs") || !loadSpec.get("path").equals(pathWithoutScheme)) {
                        loadSpec.put("type", "hdfs");
                        loadSpec.put("path", pathWithoutScheme);
                        if (updateDescriptor) {
                            log.info("Updating loadSpec in descriptor.json at [%s] with new path [%s]", new Object[]{path, pathWithoutScheme});
                            this.mapper.writeValue((OutputStream)fs.create(path, true), (Object)dataSegment);
                        }
                    }
                    segments.add(dataSegment);
                    continue;
                }
                throw new SegmentLoadingException("index.zip didn't exist at [%s] while descripter.json exists!?", new Object[]{indexZip});
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Problems interacting with filesystem[%s].", new Object[]{workingDirPath});
        }
        return segments;
    }
}

