/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.druid.segment.loading.LoadSpec;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.hdfs.HdfsDataSegmentPuller;
import java.io.File;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="hdfs")
public class HdfsLoadSpec
implements LoadSpec {
    private final Path path;
    final HdfsDataSegmentPuller puller;

    @JsonCreator
    public HdfsLoadSpec(@JacksonInject HdfsDataSegmentPuller puller, @JsonProperty(value="path", required=true) String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = new Path(path);
        this.puller = puller;
    }

    @JsonProperty(value="path")
    public final String getPathString() {
        return this.path.toString();
    }

    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.path, outDir).size());
    }
}

