/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.multibindings.MapBinder;
import com.metamx.common.logger.Logger;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.guice.Binders;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.initialization.DruidModule;
import io.druid.storage.hdfs.HdfsDataSegmentFinder;
import io.druid.storage.hdfs.HdfsDataSegmentKiller;
import io.druid.storage.hdfs.HdfsDataSegmentPuller;
import io.druid.storage.hdfs.HdfsDataSegmentPusher;
import io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import io.druid.storage.hdfs.HdfsFileTimestampVersionFinder;
import io.druid.storage.hdfs.HdfsKerberosConfig;
import io.druid.storage.hdfs.HdfsLoadSpec;
import io.druid.storage.hdfs.HdfsStorageAuthentication;
import io.druid.storage.hdfs.tasklog.HdfsTaskLogs;
import io.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class HdfsStorageDruidModule
implements DruidModule {
    private static final Logger log = new Logger(HdfsStorageDruidModule.class);
    public static final String SCHEME = "hdfs";
    private Properties props = null;

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidHDFSStorage-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{HdfsLoadSpec.class});
            }
        });
    }

    public void configure(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME).to(HdfsFileTimestampVersionFinder.class).in(LazySingleton.class);
        Binders.dataSegmentPullerBinder((Binder)binder).addBinding((Object)SCHEME).to(HdfsDataSegmentPuller.class).in(LazySingleton.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(HdfsDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(HdfsDataSegmentKiller.class).in(LazySingleton.class);
        Binders.dataSegmentFinderBinder((Binder)binder).addBinding((Object)SCHEME).to(HdfsDataSegmentFinder.class).in(LazySingleton.class);
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
        if (this.props != null) {
            for (String propName : System.getProperties().stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), System.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).toInstance((Object)conf);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", HdfsDataSegmentPusherConfig.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)SCHEME).to(HdfsTaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", HdfsTaskLogsConfig.class);
        binder.bind(HdfsTaskLogs.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.hadoop.security.kerberos", HdfsKerberosConfig.class);
        binder.bind(HdfsStorageAuthentication.class).in(ManageLifecycle.class);
        LifecycleModule.register((Binder)binder, HdfsStorageAuthentication.class);
    }
}

