/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.google.common.primitives.Longs;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.segment.BaseFloatColumnValueSelector;
import java.util.Comparator;

public class ApproximateHistogramAggregator
implements Aggregator {
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((ApproximateHistogram)o).count(), (long)((ApproximateHistogram)o1).count());
        }
    };
    private final BaseFloatColumnValueSelector selector;
    private final int resolution;
    private final float lowerLimit;
    private final float upperLimit;
    private ApproximateHistogram histogram;

    static ApproximateHistogram combineHistograms(Object lhs, Object rhs) {
        return ((ApproximateHistogram)lhs).foldFast((ApproximateHistogram)rhs);
    }

    public ApproximateHistogramAggregator(BaseFloatColumnValueSelector selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.histogram = new ApproximateHistogram(resolution, lowerLimit, upperLimit);
    }

    public void aggregate() {
        this.histogram.offer(this.selector.getFloat());
    }

    public Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getDouble()");
    }

    public void close() {
    }
}

