/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.monomorphicprocessing.HotLoopCallee;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseFloatColumnValueSelector;
import java.nio.ByteBuffer;

public class ApproximateHistogramBufferAggregator
implements BufferAggregator {
    private final BaseFloatColumnValueSelector selector;
    private final int resolution;

    public ApproximateHistogramBufferAggregator(BaseFloatColumnValueSelector selector, int resolution) {
        this.selector = selector;
        this.resolution = resolution;
    }

    public void init(ByteBuffer buf, int position) {
        int i;
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.putInt(this.resolution);
        mutationBuffer.putInt(0);
        for (i = 0; i < this.resolution; ++i) {
            mutationBuffer.putFloat(0.0f);
        }
        for (i = 0; i < this.resolution; ++i) {
            mutationBuffer.putLong(0L);
        }
        mutationBuffer.putFloat(Float.POSITIVE_INFINITY);
        mutationBuffer.putFloat(Float.NEGATIVE_INFINITY);
    }

    public void aggregate(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        ApproximateHistogram h0 = ApproximateHistogram.fromBytesDense(mutationBuffer);
        h0.offer(this.selector.getFloat());
        mutationBuffer.position(position);
        h0.toBytesDense(mutationBuffer);
    }

    public Object get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        return ApproximateHistogram.fromBytes(mutationBuffer);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getLong()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getDouble()");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (HotLoopCallee)this.selector);
    }
}

