/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.segment.BaseObjectColumnValueSelector;

public class ApproximateHistogramFoldingAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector<ApproximateHistogram> selector;
    private final int resolution;
    private final float lowerLimit;
    private final float upperLimit;
    private ApproximateHistogram histogram;
    private float[] tmpBufferP;
    private long[] tmpBufferB;

    public ApproximateHistogramFoldingAggregator(BaseObjectColumnValueSelector<ApproximateHistogram> selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.histogram = new ApproximateHistogram(resolution, lowerLimit, upperLimit);
        this.tmpBufferP = new float[resolution];
        this.tmpBufferB = new long[resolution];
    }

    public void aggregate() {
        ApproximateHistogram h = (ApproximateHistogram)this.selector.getObject();
        if (h == null) {
            return;
        }
        if (h.binCount() + this.histogram.binCount() <= this.tmpBufferB.length) {
            this.histogram.foldFast(h, this.tmpBufferP, this.tmpBufferB);
        } else {
            this.histogram.foldFast(h);
        }
    }

    public Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingAggregator does not support getDouble()");
    }

    public void close() {
    }
}

