/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.google.common.base.Supplier;
import com.google.common.collect.Ordering;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramAggregator;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class ApproximateHistogramFoldingSerde
extends ComplexMetricSerde {
    private static Ordering<ApproximateHistogram> comparator = new Ordering<ApproximateHistogram>(){

        public int compare(ApproximateHistogram arg1, ApproximateHistogram arg2) {
            return ApproximateHistogramAggregator.COMPARATOR.compare(arg1, arg2);
        }
    }.nullsFirst();

    public String getTypeName() {
        return "approximateHistogram";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<ApproximateHistogram> extractedClass() {
                return ApproximateHistogram.class;
            }

            public ApproximateHistogram extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof ApproximateHistogram) {
                    return (ApproximateHistogram)rawValue;
                }
                List dimValues = inputRow.getDimension(metricName);
                if (dimValues != null && dimValues.size() > 0) {
                    Iterator values = dimValues.iterator();
                    ApproximateHistogram h = new ApproximateHistogram();
                    while (values.hasNext()) {
                        float value = Float.parseFloat((String)values.next());
                        h.offer(value);
                    }
                    return h;
                }
                return new ApproximateHistogram(0);
            }
        };
    }

    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read((ByteBuffer)byteBuffer, (ObjectStrategy)this.getObjectStrategy(), (SmooshedFileMapper)columnBuilder.getFileMapper());
        columnBuilder.setComplexColumn((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, (ObjectStrategy)this.getObjectStrategy());
    }

    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<ApproximateHistogram>(){

            public Class<? extends ApproximateHistogram> getClazz() {
                return ApproximateHistogram.class;
            }

            public ApproximateHistogram fromByteBuffer(ByteBuffer buffer, int numBytes) {
                buffer.limit(buffer.position() + numBytes);
                return ApproximateHistogram.fromBytes(buffer);
            }

            public byte[] toBytes(ApproximateHistogram h) {
                if (h == null) {
                    return new byte[0];
                }
                return h.toBytes();
            }

            public int compare(ApproximateHistogram o1, ApproximateHistogram o2) {
                return comparator.compare((Object)o1, (Object)o2);
            }
        };
    }
}

