/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="equalBuckets")
public class EqualBucketsPostAggregator
extends ApproximateHistogramPostAggregator {
    private final int numBuckets;

    @JsonCreator
    public EqualBucketsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="numBuckets") int numBuckets) {
        super(name, fieldName);
        this.numBuckets = numBuckets;
        if (this.numBuckets <= 1) {
            throw new IAE("Illegal number of buckets[%s], must be > 1", new Object[]{this.numBuckets});
        }
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return ah.toHistogram(this.numBuckets);
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    public String toString() {
        return "EqualBucketsPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", numBuckets=" + this.numBuckets + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(12).appendString(this.fieldName).appendInt(this.numBuckets).build();
    }
}

