/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="max")
public class MaxPostAggregator
extends ApproximateHistogramPostAggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Double.compare(((Number)o).doubleValue(), ((Number)o1).doubleValue());
        }
    };

    @JsonCreator
    public MaxPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        super(name, fieldName);
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return Float.valueOf(ah.getMax());
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @Override
    public String toString() {
        return "QuantilePostAggregator{fieldName='" + this.fieldName + '\'' + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(13).appendString(this.fieldName).build();
    }
}

