/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="quantile")
public class QuantilePostAggregator
extends ApproximateHistogramPostAggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Double.compare(((Number)o).doubleValue(), ((Number)o1).doubleValue());
        }
    };
    private final float probability;
    private final String fieldName;

    @JsonCreator
    public QuantilePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probability") float probability) {
        super(name, fieldName);
        this.probability = probability;
        this.fieldName = fieldName;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(probability)});
        }
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return Float.valueOf(ah.getQuantiles(new float[]{this.probability})[0]);
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float getProbability() {
        return this.probability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantilePostAggregator that = (QuantilePostAggregator)o;
        if (Float.compare(that.probability, this.probability) != 0) {
            return false;
        }
        return this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null;
    }

    public int hashCode() {
        int result = this.probability != 0.0f ? Float.floatToIntBits(this.probability) : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "QuantilePostAggregator{probability=" + this.probability + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(15).appendString(this.fieldName).appendFloat(this.probability).build();
    }
}

