/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import io.druid.query.aggregation.histogram.Quantiles;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="quantiles")
public class QuantilesPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float[] probabilities;

    @JsonCreator
    public QuantilesPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probabilities") float[] probabilities) {
        super(name, fieldName);
        this.probabilities = probabilities;
        for (float p : probabilities) {
            if (!(p < 0.0f) && !(p > 1.0f)) continue;
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(p)});
        }
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return new Quantiles(this.probabilities, ah.getQuantiles(this.probabilities), ah.getMin(), ah.getMax());
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float[] getProbabilities() {
        return this.probabilities;
    }

    @Override
    public String toString() {
        return "EqualBucketsPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", probabilities=" + Arrays.toString(this.getProbabilities()) + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(16).appendString(this.fieldName).appendFloatArray(this.probabilities).build();
    }
}

