/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram.sql;

import com.google.common.collect.ImmutableList;
import io.druid.java.util.common.StringUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogramAggregatorFactory;
import io.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregatorFactory;
import io.druid.query.aggregation.histogram.QuantilePostAggregator;
import io.druid.segment.VirtualColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class QuantileSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new QuantileSqlAggFunction();
    private static final String NAME = "APPROX_QUANTILE";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        ApproximateHistogramAggregatorFactory aggregatorFactory;
        int resolution;
        DruidExpression input = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0))));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        RexNode probabilityArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(1)));
        if (!probabilityArg.isA(SqlKind.LITERAL)) {
            return null;
        }
        float probability = ((Number)((Object)RexLiteral.value((RexNode)probabilityArg))).floatValue();
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode resolutionArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(2)));
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            resolution = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            resolution = 50;
        }
        int numBuckets = 7;
        float lowerLimit = Float.NEGATIVE_INFINITY;
        float upperLimit = Float.POSITIVE_INFINITY;
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                if (!(factory instanceof ApproximateHistogramAggregatorFactory)) continue;
                ApproximateHistogramAggregatorFactory theFactory = (ApproximateHistogramAggregatorFactory)factory;
                VirtualColumn virtualInput = existing.getVirtualColumns().stream().filter(virtualColumn -> virtualColumn.getOutputName().equals(theFactory.getFieldName())).findFirst().orElse(null);
                boolean inputMatches = virtualInput == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(theFactory.getFieldName()) : ((ExpressionVirtualColumn)virtualInput).getExpression().equals(input.getExpression());
                boolean matches = inputMatches && theFactory.getResolution() == resolution && theFactory.getNumBuckets() == 7 && theFactory.getLowerLimit() == Float.NEGATIVE_INFINITY && theFactory.getUpperLimit() == Float.POSITIVE_INFINITY;
                if (!matches) continue;
                return Aggregation.create((List)ImmutableList.of(), (PostAggregator)new QuantilePostAggregator(name, factory.getName(), probability));
            }
        }
        ArrayList<ExpressionVirtualColumn> virtualColumns = new ArrayList<ExpressionVirtualColumn>();
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = rowSignature.getColumnType(input.getDirectColumn()) == ValueType.COMPLEX ? new ApproximateHistogramFoldingAggregatorFactory(histogramName, input.getDirectColumn(), resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY)) : new ApproximateHistogramAggregatorFactory(histogramName, input.getDirectColumn(), resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
        } else {
            ExpressionVirtualColumn virtualColumn2 = input.toVirtualColumn(StringUtils.format((String)"%s:v", (Object[])new Object[]{name}), ValueType.FLOAT, plannerContext.getExprMacroTable());
            virtualColumns.add(virtualColumn2);
            aggregatorFactory = new ApproximateHistogramAggregatorFactory(histogramName, virtualColumn2.getOutputName(), resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
        }
        return Aggregation.create(virtualColumns, (List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)new QuantilePostAggregator(name, histogramName, probability));
    }

    private static class QuantileSqlAggFunction
    extends SqlAggFunction {
        private static final String SIGNATURE1 = "'APPROX_QUANTILE(column, probability)'\n";
        private static final String SIGNATURE2 = "'APPROX_QUANTILE(column, probability, resolution)'\n";

        QuantileSqlAggFunction() {
            super(QuantileSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE1, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE2, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.EXACT_NUMERIC})})}), SqlFunctionCategory.NUMERIC, false, false);
        }
    }
}

