/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogramBufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregatorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

@JsonTypeName(value="approxHistogram")
public class ApproximateHistogramAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 12;
    protected final String name;
    protected final String fieldName;
    protected final int resolution;
    protected final int numBuckets;
    protected final float lowerLimit;
    protected final float upperLimit;

    @JsonCreator
    public ApproximateHistogramAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="resolution") Integer resolution, @JsonProperty(value="numBuckets") Integer numBuckets, @JsonProperty(value="lowerLimit") Float lowerLimit, @JsonProperty(value="upperLimit") Float upperLimit) {
        this.name = name;
        this.fieldName = fieldName;
        this.resolution = resolution == null ? 50 : resolution;
        this.numBuckets = numBuckets == null ? 7 : numBuckets;
        this.lowerLimit = lowerLimit == null ? Float.NEGATIVE_INFINITY : lowerLimit.floatValue();
        this.upperLimit = upperLimit == null ? Float.POSITIVE_INFINITY : upperLimit.floatValue();
        Preconditions.checkArgument((this.resolution > 0 ? 1 : 0) != 0, (Object)"resolution must be greater than 1");
        Preconditions.checkArgument((this.numBuckets > 0 ? 1 : 0) != 0, (Object)"numBuckets must be greater than 1");
        Preconditions.checkArgument((this.upperLimit > this.lowerLimit ? 1 : 0) != 0, (Object)"upperLimit must be greater than lowerLimit");
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new ApproximateHistogramAggregator(this.name, metricFactory.makeFloatColumnSelector(this.fieldName), this.resolution, this.lowerLimit, this.upperLimit);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new ApproximateHistogramBufferAggregator(metricFactory.makeFloatColumnSelector(this.fieldName), this.resolution, this.lowerLimit, this.upperLimit);
    }

    public Comparator getComparator() {
        return ApproximateHistogramAggregator.COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        return ApproximateHistogramAggregator.combineHistograms(lhs, rhs);
    }

    public AggregatorFactory getCombiningFactory() {
        return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit));
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof ApproximateHistogramAggregatorFactory) {
            ApproximateHistogramAggregatorFactory castedOther = (ApproximateHistogramAggregatorFactory)other;
            return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, Math.max(this.resolution, castedOther.resolution), this.numBuckets, Float.valueOf(Math.min(this.lowerLimit, castedOther.lowerLimit)), Float.valueOf(Math.max(this.upperLimit, castedOther.upperLimit)));
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new AggregatorFactory[]{new ApproximateHistogramAggregatorFactory(this.fieldName, this.fieldName, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit))});
    }

    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            ApproximateHistogram ah = ApproximateHistogram.fromBytes((byte[])object);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        if (object instanceof ByteBuffer) {
            ApproximateHistogram ah = ApproximateHistogram.fromBytes((ByteBuffer)object);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        if (object instanceof String) {
            byte[] bytes = Base64.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)));
            ApproximateHistogram ah = ApproximateHistogram.fromBytes(bytes);
            ah.setLowerLimit(this.lowerLimit);
            ah.setUpperLimit(this.upperLimit);
            return ah;
        }
        return object;
    }

    public Object finalizeComputation(Object object) {
        return ((ApproximateHistogram)object).toHistogram(this.numBuckets);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getResolution() {
        return this.resolution;
    }

    @JsonProperty
    public float getLowerLimit() {
        return this.lowerLimit;
    }

    @JsonProperty
    public float getUpperLimit() {
        return this.upperLimit;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length + 8 + 8).put((byte)12).put(fieldNameBytes).putInt(this.resolution).putInt(this.numBuckets).putFloat(this.lowerLimit).putFloat(this.upperLimit).array();
    }

    public String getTypeName() {
        return "approximateHistogram";
    }

    public int getMaxIntermediateSize() {
        return new ApproximateHistogram(this.resolution).getMaxStorageSize();
    }

    public Object getAggregatorStartValue() {
        return new ApproximateHistogram(this.resolution);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ApproximateHistogramAggregatorFactory that = (ApproximateHistogramAggregatorFactory)((Object)o);
        if (Float.compare(that.lowerLimit, this.lowerLimit) != 0) {
            return false;
        }
        if (this.numBuckets != that.numBuckets) {
            return false;
        }
        if (this.resolution != that.resolution) {
            return false;
        }
        if (Float.compare(that.upperLimit, this.upperLimit) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + this.resolution;
        result = 31 * result + this.numBuckets;
        result = 31 * result + (this.lowerLimit != 0.0f ? Float.floatToIntBits(this.lowerLimit) : 0);
        result = 31 * result + (this.upperLimit != 0.0f ? Float.floatToIntBits(this.upperLimit) : 0);
        return result;
    }

    public String toString() {
        return "ApproximateHistogramAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", resolution=" + this.resolution + ", numBuckets=" + this.numBuckets + ", lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + '}';
    }
}

