/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="buckets")
public class BucketsPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float bucketSize;
    private final float offset;
    private String fieldName;

    @JsonCreator
    public BucketsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="bucketSize") float bucketSize, @JsonProperty(value="offset") float offset) {
        super(name, fieldName);
        this.bucketSize = bucketSize;
        if (this.bucketSize <= 0.0f) {
            throw new IAE("Illegal bucketSize [%s], must be > 0", new Object[]{Float.valueOf(this.bucketSize)});
        }
        this.offset = offset;
        this.fieldName = fieldName;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.getFieldName());
        return ah.toHistogram(this.bucketSize, this.offset);
    }

    @JsonProperty
    public float getBucketSize() {
        return this.bucketSize;
    }

    @JsonProperty
    public float getOffset() {
        return this.bucketSize;
    }

    @Override
    public String toString() {
        return "BucketsPostAggregator{name='" + this.getName() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", bucketSize=" + this.getBucketSize() + ", offset=" + this.getOffset() + '}';
    }
}

