/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;

public class ApproximateHistogramFoldingBufferAggregator
implements BufferAggregator {
    private final ObjectColumnSelector<ApproximateHistogram> selector;
    private final int resolution;
    private final float upperLimit;
    private final float lowerLimit;
    private float[] tmpBufferP;
    private long[] tmpBufferB;

    public ApproximateHistogramFoldingBufferAggregator(ObjectColumnSelector<ApproximateHistogram> selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.tmpBufferP = new float[resolution];
        this.tmpBufferB = new long[resolution];
    }

    public void init(ByteBuffer buf, int position) {
        ApproximateHistogram h = new ApproximateHistogram(this.resolution, this.lowerLimit, this.upperLimit);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        h.toBytesDense(mutationBuffer);
    }

    public void aggregate(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        ApproximateHistogram h0 = ApproximateHistogram.fromBytesDense(mutationBuffer);
        h0.setLowerLimit(this.lowerLimit);
        h0.setUpperLimit(this.upperLimit);
        ApproximateHistogram hNext = (ApproximateHistogram)this.selector.get();
        h0.foldFast(hNext, this.tmpBufferP, this.tmpBufferB);
        mutationBuffer.position(position);
        h0.toBytesDense(mutationBuffer);
    }

    public Object get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.asReadOnlyBuffer();
        mutationBuffer.position(position);
        return ApproximateHistogram.fromBytesDense(mutationBuffer);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingBufferAggregator does not support getLong()");
    }

    public void close() {
    }
}

