/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.druid.indexing.kafka.KafkaPartitions;
import io.druid.indexing.overlord.DataSourceMetadata;
import io.druid.java.util.common.IAE;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaDataSourceMetadata
implements DataSourceMetadata {
    private final KafkaPartitions kafkaPartitions;

    @JsonCreator
    public KafkaDataSourceMetadata(@JsonProperty(value="partitions") KafkaPartitions kafkaPartitions) {
        this.kafkaPartitions = kafkaPartitions;
    }

    @JsonProperty(value="partitions")
    public KafkaPartitions getKafkaPartitions() {
        return this.kafkaPartitions;
    }

    public boolean isValidStart() {
        return true;
    }

    public boolean matches(DataSourceMetadata other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.plus(other).equals(other.plus((DataSourceMetadata)this));
    }

    public DataSourceMetadata plus(DataSourceMetadata other) {
        if (!(other instanceof KafkaDataSourceMetadata)) {
            throw new IAE("Expected instance of %s, got %s", new Object[]{KafkaDataSourceMetadata.class.getCanonicalName(), other.getClass().getCanonicalName()});
        }
        KafkaDataSourceMetadata that = (KafkaDataSourceMetadata)other;
        if (that.getKafkaPartitions().getTopic().equals(this.kafkaPartitions.getTopic())) {
            HashMap newMap = Maps.newHashMap();
            for (Map.Entry<Integer, Long> entry : this.kafkaPartitions.getPartitionOffsetMap().entrySet()) {
                newMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Integer, Long> entry : that.getKafkaPartitions().getPartitionOffsetMap().entrySet()) {
                newMap.put(entry.getKey(), entry.getValue());
            }
            return new KafkaDataSourceMetadata(new KafkaPartitions(this.kafkaPartitions.getTopic(), newMap));
        }
        return other;
    }

    public DataSourceMetadata minus(DataSourceMetadata other) {
        if (!(other instanceof KafkaDataSourceMetadata)) {
            throw new IAE("Expected instance of %s, got %s", new Object[]{KafkaDataSourceMetadata.class.getCanonicalName(), other.getClass().getCanonicalName()});
        }
        KafkaDataSourceMetadata that = (KafkaDataSourceMetadata)other;
        if (that.getKafkaPartitions().getTopic().equals(this.kafkaPartitions.getTopic())) {
            HashMap newMap = Maps.newHashMap();
            for (Map.Entry<Integer, Long> entry : this.kafkaPartitions.getPartitionOffsetMap().entrySet()) {
                if (that.getKafkaPartitions().getPartitionOffsetMap().containsKey(entry.getKey())) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            return new KafkaDataSourceMetadata(new KafkaPartitions(this.kafkaPartitions.getTopic(), newMap));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDataSourceMetadata that = (KafkaDataSourceMetadata)o;
        return Objects.equals(this.kafkaPartitions, that.kafkaPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.kafkaPartitions);
    }

    public String toString() {
        return "KafkaDataSourceMetadata{kafkaPartitions=" + this.kafkaPartitions + '}';
    }
}

