/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.guice.annotations.Json;
import io.druid.indexing.kafka.KafkaIndexTaskClientFactory;
import io.druid.indexing.kafka.supervisor.KafkaSupervisor;
import io.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import io.druid.indexing.kafka.supervisor.KafkaSupervisorTuningConfig;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.supervisor.Supervisor;
import io.druid.indexing.overlord.supervisor.SupervisorSpec;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.segment.indexing.DataSchema;
import io.druid.server.metrics.DruidMonitorSchedulerConfig;
import java.util.List;
import java.util.Map;

public class KafkaSupervisorSpec
implements SupervisorSpec {
    private final DataSchema dataSchema;
    private final KafkaSupervisorTuningConfig tuningConfig;
    private final KafkaSupervisorIOConfig ioConfig;
    private final Map<String, Object> context;
    private final TaskStorage taskStorage;
    private final TaskMaster taskMaster;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final KafkaIndexTaskClientFactory kafkaIndexTaskClientFactory;
    private final ObjectMapper mapper;
    private final ServiceEmitter emitter;
    private final DruidMonitorSchedulerConfig monitorSchedulerConfig;

    @JsonCreator
    public KafkaSupervisorSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaSupervisorTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaSupervisorIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject KafkaIndexTaskClientFactory kafkaIndexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper, @JacksonInject ServiceEmitter emitter, @JacksonInject DruidMonitorSchedulerConfig monitorSchedulerConfig) {
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.tuningConfig = tuningConfig != null ? tuningConfig : new KafkaSupervisorTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.ioConfig = (KafkaSupervisorIOConfig)Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
        this.context = context;
        this.taskStorage = taskStorage;
        this.taskMaster = taskMaster;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.kafkaIndexTaskClientFactory = kafkaIndexTaskClientFactory;
        this.mapper = mapper;
        this.emitter = emitter;
        this.monitorSchedulerConfig = monitorSchedulerConfig;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public KafkaSupervisorTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public KafkaSupervisorIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public String getId() {
        return this.dataSchema.getDataSource();
    }

    public DruidMonitorSchedulerConfig getMonitorSchedulerConfig() {
        return this.monitorSchedulerConfig;
    }

    public Supervisor createSupervisor() {
        return new KafkaSupervisor(this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, this.kafkaIndexTaskClientFactory, this.mapper, this);
    }

    public List<String> getDataSources() {
        return ImmutableList.of((Object)this.getDataSchema().getDataSource());
    }

    public String toString() {
        return "KafkaSupervisorSpec{dataSchema=" + this.dataSchema + ", tuningConfig=" + this.tuningConfig + ", ioConfig=" + this.ioConfig + '}';
    }
}

