/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.indexing.kafka.KafkaTuningConfig;
import io.druid.segment.IndexSpec;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.File;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaSupervisorTuningConfig
extends KafkaTuningConfig {
    private final Integer workerThreads;
    private final Integer chatThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;
    private final Duration offsetFetchPeriod;

    public KafkaSupervisorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatThreads") Integer chatThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout, @JsonProperty(value="offsetFetchPeriod") Period offsetFetchPeriod) {
        super(maxRowsInMemory, maxRowsPerSegment, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, true, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, segmentWriteOutMediumFactory);
        this.workerThreads = workerThreads;
        this.chatThreads = chatThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = KafkaSupervisorTuningConfig.defaultDuration(httpTimeout, "PT10S");
        this.shutdownTimeout = KafkaSupervisorTuningConfig.defaultDuration(shutdownTimeout, "PT80S");
        this.offsetFetchPeriod = KafkaSupervisorTuningConfig.defaultDuration(offsetFetchPeriod, "PT30S");
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Integer getChatThreads() {
        return this.chatThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @JsonProperty
    public Duration getOffsetFetchPeriod() {
        return this.offsetFetchPeriod;
    }

    @Override
    public String toString() {
        return "KafkaSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", segmentWriteOutMediumFactory=" + this.getSegmentWriteOutMediumFactory() + ", workerThreads=" + this.workerThreads + ", chatThreads=" + this.chatThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + this.httpTimeout + ", shutdownTimeout=" + this.shutdownTimeout + ", offsetFetchPeriod=" + this.offsetFetchPeriod + '}';
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }
}

