/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.http.client.HttpClient;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Json;
import io.druid.indexing.common.TaskInfoProvider;
import io.druid.indexing.kafka.KafkaIndexTaskClient;
import org.joda.time.Duration;

public class KafkaIndexTaskClientFactory {
    private HttpClient httpClient;
    private ObjectMapper mapper;

    @Inject
    public KafkaIndexTaskClientFactory(@Global HttpClient httpClient, @Json ObjectMapper mapper) {
        this.httpClient = httpClient;
        this.mapper = mapper;
    }

    public KafkaIndexTaskClient build(TaskInfoProvider taskInfoProvider, String dataSource, int numThreads, Duration httpTimeout, long numRetries) {
        return new KafkaIndexTaskClient(this.httpClient, this.mapper, taskInfoProvider, dataSource, numThreads, httpTimeout, numRetries);
    }
}

