/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.indexing.kafka.KafkaTuningConfig;
import io.druid.segment.IndexSpec;
import java.io.File;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaSupervisorTuningConfig
extends KafkaTuningConfig {
    private final Integer workerThreads;
    private final Integer chatThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;

    public KafkaSupervisorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatThreads") Integer chatThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout) {
        super(maxRowsInMemory, maxRowsPerSegment, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, buildV9Directly, reportParseExceptions, handoffConditionTimeout);
        this.workerThreads = workerThreads;
        this.chatThreads = chatThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = KafkaSupervisorTuningConfig.defaultDuration(httpTimeout, "PT10S");
        this.shutdownTimeout = KafkaSupervisorTuningConfig.defaultDuration(shutdownTimeout, "PT80S");
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Integer getChatThreads() {
        return this.chatThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Override
    public String toString() {
        return "KafkaSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", buildV9Directly=" + this.getBuildV9Directly() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", workerThreads=" + this.workerThreads + ", chatThreads=" + this.chatThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + this.httpTimeout + ", shutdownTimeout=" + this.shutdownTimeout + '}';
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }
}

