/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.joda.time.DateTime;

public class TaskReportData {
    private final String id;
    private final Map<Integer, Long> startingOffsets;
    private final DateTime startTime;
    private final Long remainingSeconds;
    private final TaskType type;
    private Map<Integer, Long> currentOffsets;

    public TaskReportData(String id, Map<Integer, Long> startingOffsets, Map<Integer, Long> currentOffsets, DateTime startTime, Long remainingSeconds, TaskType type) {
        this.id = id;
        this.startingOffsets = startingOffsets;
        this.currentOffsets = currentOffsets;
        this.startTime = startTime;
        this.remainingSeconds = remainingSeconds;
        this.type = type;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public Map<Integer, Long> getStartingOffsets() {
        return this.startingOffsets;
    }

    @JsonProperty
    public Map<Integer, Long> getCurrentOffsets() {
        return this.currentOffsets;
    }

    public void setCurrentOffsets(Map<Integer, Long> currentOffsets) {
        this.currentOffsets = currentOffsets;
    }

    @JsonProperty
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Long getRemainingSeconds() {
        return this.remainingSeconds;
    }

    @JsonProperty
    public TaskType getType() {
        return this.type;
    }

    public String toString() {
        return "{id='" + this.id + '\'' + (this.startingOffsets != null ? ", startingOffsets=" + this.startingOffsets : "") + (this.currentOffsets != null ? ", currentOffsets=" + this.currentOffsets : "") + ", startTime=" + this.startTime + ", remainingSeconds=" + this.remainingSeconds + '}';
    }

    public static enum TaskType {
        ACTIVE,
        PUBLISHING,
        UNKNOWN;

    }
}

