/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.lookup.LookupExtractor;
import io.druid.server.lookup.DataFetcher;
import io.druid.server.lookup.LookupExtractionModule;
import io.druid.server.lookup.cache.loading.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class LoadingLookup
extends LookupExtractor {
    private static final Logger LOGGER = new Logger(LoadingLookup.class);
    private final DataFetcher<String, String> dataFetcher;
    private final LoadingCache<String, String> loadingCache;
    private final LoadingCache<String, List<String>> reverseLoadingCache;
    private final AtomicBoolean isOpen;
    private final String id = Integer.toHexString(System.identityHashCode((Object)this));

    public LoadingLookup(DataFetcher dataFetcher, LoadingCache<String, String> loadingCache, LoadingCache<String, List<String>> reverseLoadingCache) {
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher, (Object)"lookup must have a DataFetcher");
        this.loadingCache = (LoadingCache)Preconditions.checkNotNull(loadingCache, (Object)"loading lookup need a cache");
        this.reverseLoadingCache = (LoadingCache)Preconditions.checkNotNull(reverseLoadingCache, (Object)"loading lookup need reverse cache");
        this.isOpen = new AtomicBoolean(true);
    }

    public String apply(String key) {
        if (key == null) {
            return null;
        }
        try {
            String presentVal = this.loadingCache.get(key, new ApplyCallable(key));
            return Strings.emptyToNull((String)presentVal);
        }
        catch (ExecutionException e) {
            LOGGER.debug("value not found for key [%s]", new Object[]{key});
            return null;
        }
    }

    public List<String> unapply(String value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            List<String> retList = this.reverseLoadingCache.get(value, new UnapplyCallable(value));
            return retList;
        }
        catch (ExecutionException e) {
            LOGGER.debug("list of keys not found for value [%s]", new Object[]{value});
            return Collections.EMPTY_LIST;
        }
    }

    public synchronized void close() {
        if (!this.isOpen.getAndSet(false)) {
            LOGGER.info("Closing already closed lookup", new Object[0]);
            return;
        }
        LOGGER.info("Closing loading cache [%s]", new Object[]{this.id});
        this.loadingCache.close();
        this.reverseLoadingCache.close();
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public byte[] getCacheKey() {
        return LookupExtractionModule.getRandomCacheKey();
    }

    public String toString() {
        return "LoadingLookup{dataFetcher=" + this.dataFetcher + ", id='" + this.id + '\'' + '}';
    }

    private class UnapplyCallable
    implements Callable<List<String>> {
        private final String value;

        public UnapplyCallable(String value) {
            this.value = value;
        }

        @Override
        public List<String> call() throws Exception {
            return LoadingLookup.this.dataFetcher.reverseFetchKeys(this.value);
        }
    }

    private class ApplyCallable
    implements Callable<String> {
        private final String key;

        public ApplyCallable(String key) {
            this.key = key;
        }

        @Override
        public String call() throws Exception {
            return Strings.nullToEmpty((String)((String)LoadingLookup.this.dataFetcher.fetch(this.key)));
        }
    }
}

