/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.lookup.LookupExtractor;
import io.druid.server.lookup.DataFetcher;
import io.druid.server.lookup.LookupExtractionModule;
import io.druid.server.lookup.cache.polling.OnHeapPollingCache;
import io.druid.server.lookup.cache.polling.PollingCache;
import io.druid.server.lookup.cache.polling.PollingCacheFactory;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;

public class PollingLookup
extends LookupExtractor {
    private static final Logger LOGGER = new Logger(PollingLookup.class);
    private final long pollPeriodMs;
    private final DataFetcher dataFetcher;
    private final PollingCacheFactory cacheFactory;
    private final AtomicReference<CacheRefKeeper> refOfCacheKeeper = new AtomicReference();
    private final ListeningScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final ListenableFuture<?> pollFuture;
    private final String id = Integer.toHexString(System.identityHashCode((Object)this));

    public PollingLookup(long pollPeriodMs, DataFetcher dataFetcher, PollingCacheFactory cacheFactory) {
        this.pollPeriodMs = pollPeriodMs;
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher);
        this.cacheFactory = cacheFactory == null ? new OnHeapPollingCache.OnHeapPollingCacheProvider() : cacheFactory;
        this.refOfCacheKeeper.set(new CacheRefKeeper(this.cacheFactory.makeOf(dataFetcher.fetchAll())));
        if (pollPeriodMs > 0L) {
            this.scheduledExecutorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(Execs.makeThreadFactory((String)("PollingLookup-" + this.id), (Integer)1)));
            this.pollFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.pollAndSwap(), pollPeriodMs, pollPeriodMs, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledExecutorService = null;
            this.pollFuture = null;
        }
        this.isOpen.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Closing polling lookup [%s]", new Object[]{this.id});
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            CacheRefKeeper cacheRefKeeper;
            this.isOpen.getAndSet(false);
            if (this.pollFuture != null) {
                this.pollFuture.cancel(true);
                this.scheduledExecutorService.shutdown();
            }
            if ((cacheRefKeeper = (CacheRefKeeper)this.refOfCacheKeeper.getAndSet(null)) != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apply(@NotNull String key) {
        CacheRefKeeper cacheRefKeeper = this.refOfCacheKeeper.get();
        if (cacheRefKeeper == null) {
            throw new ISE("Cache reference is null WTF", new Object[0]);
        }
        PollingCache cache = cacheRefKeeper.getAndIncrementRef();
        try {
            if (cache == null) {
                String string = this.apply(key);
                return string;
            }
            String string = Strings.emptyToNull((String)((String)cache.get(key)));
            return string;
        }
        finally {
            if (cacheRefKeeper != null && cache != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> unapply(String value) {
        CacheRefKeeper cacheRefKeeper = this.refOfCacheKeeper.get();
        if (cacheRefKeeper == null) {
            throw new ISE("pollingLookup id [%s] is closed", new Object[]{this.id});
        }
        PollingCache cache = cacheRefKeeper.getAndIncrementRef();
        try {
            if (cache == null) {
                List<String> list = this.unapply(value);
                return list;
            }
            List<String> list = cache.getKeys(value);
            return list;
        }
        finally {
            if (cacheRefKeeper != null && cache != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    public byte[] getCacheKey() {
        return LookupExtractionModule.getRandomCacheKey();
    }

    private Runnable pollAndSwap() {
        return new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("Polling and swapping of PollingLookup [%s]", new Object[]{PollingLookup.this.id});
                CacheRefKeeper newCacheKeeper = new CacheRefKeeper(PollingLookup.this.cacheFactory.makeOf(PollingLookup.this.dataFetcher.fetchAll()));
                CacheRefKeeper oldCacheKeeper = PollingLookup.this.refOfCacheKeeper.getAndSet(newCacheKeeper);
                if (oldCacheKeeper != null) {
                    oldCacheKeeper.doneWithIt();
                }
            }
        };
    }

    public int hashCode() {
        int result = (int)(this.pollPeriodMs ^ this.pollPeriodMs >>> 32);
        result = 31 * result + this.dataFetcher.hashCode();
        result = 31 * result + this.cacheFactory.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingLookup)) {
            return false;
        }
        PollingLookup that = (PollingLookup)((Object)o);
        if (this.pollPeriodMs != that.pollPeriodMs) {
            return false;
        }
        if (!this.dataFetcher.equals(that.dataFetcher)) {
            return false;
        }
        return this.cacheFactory.equals(that.cacheFactory);
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public String toString() {
        return "PollingLookup{dataFetcher=" + this.dataFetcher + ", id='" + this.id + '\'' + '}';
    }

    protected static class CacheRefKeeper {
        private final PollingCache pollingCache;
        private final AtomicLong refCounts = new AtomicLong(0L);

        CacheRefKeeper(PollingCache pollingCache) {
            this.pollingCache = pollingCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PollingCache getAndIncrementRef() {
            AtomicLong atomicLong = this.refCounts;
            synchronized (atomicLong) {
                if (this.refCounts.get() < 0L) {
                    return null;
                }
                this.refCounts.incrementAndGet();
                return this.pollingCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWithIt() {
            AtomicLong atomicLong = this.refCounts;
            synchronized (atomicLong) {
                if (this.refCounts.get() == 0L) {
                    this.pollingCache.close();
                }
                this.refCounts.decrementAndGet();
            }
        }
    }
}

