/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache.loading;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.druid.server.lookup.cache.loading.LookupCacheStats;
import io.druid.server.lookup.cache.loading.OffHeapLoadingCache;
import io.druid.server.lookup.cache.loading.OnHeapLoadingCache;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="guava", value=OnHeapLoadingCache.class), @JsonSubTypes.Type(name="mapDb", value=OffHeapLoadingCache.class)})
public interface LoadingCache<K, V>
extends Closeable {
    @Nullable
    public V getIfPresent(K var1);

    public Map<K, V> getAllPresent(Iterable<K> var1);

    public V get(K var1, Callable<? extends V> var2) throws ExecutionException;

    public void putAll(Map<? extends K, ? extends V> var1);

    public void invalidate(K var1);

    public void invalidateAll(Iterable<K> var1);

    public void invalidateAll();

    public LookupCacheStats getStats();

    public boolean isClosed();

    @Override
    public void close();
}

