/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache.loading;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.ISE;
import io.druid.server.lookup.cache.loading.LoadingCache;
import io.druid.server.lookup.cache.loading.LookupCacheStats;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class OffHeapLoadingCache<K, V>
implements LoadingCache<K, V> {
    private static final DB DB = DBMaker.newMemoryDirectDB().transactionDisable().closeOnJvmShutdown().make();
    private final HTreeMap<K, V> cache;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong evictionCount = new AtomicLong(0L);
    private final AtomicBoolean closed = new AtomicBoolean(true);
    @JsonProperty
    private final double maxStoreSize;
    @JsonProperty
    private final long maxEntriesSize;
    @JsonProperty
    private final long expireAfterWrite;
    @JsonProperty
    private final long expireAfterAccess;
    private final String name = UUID.randomUUID().toString();

    @JsonCreator
    public OffHeapLoadingCache(@JsonProperty(value="maxStoreSize") double maxStoreSize, @JsonProperty(value="maxEntriesSize") long maxEntriesSize, @JsonProperty(value="expireAfterWrite") long expireAfterWrite, @JsonProperty(value="expireAfterAccess") long expireAfterAccess) {
        this.maxStoreSize = maxStoreSize;
        this.maxEntriesSize = maxEntriesSize;
        this.expireAfterWrite = expireAfterWrite;
        this.expireAfterAccess = expireAfterAccess;
        this.cache = DB.createHashMap(this.name).expireStoreSize(this.maxStoreSize).expireAfterWrite(this.expireAfterWrite, TimeUnit.MILLISECONDS).expireAfterAccess(this.expireAfterAccess, TimeUnit.MILLISECONDS).expireMaxSize(this.maxEntriesSize).make();
        this.cache.modificationListenerAdd(new Bind.MapListener<K, V>(){

            public void update(K key, V oldVal, V newVal) {
                if (oldVal != null && newVal == null) {
                    OffHeapLoadingCache.this.evictionCount.getAndIncrement();
                }
            }
        });
        this.closed.set(false);
    }

    @Override
    public V getIfPresent(K key) {
        Object value = this.cache.get(key);
        if (value == null) {
            this.missCount.getAndIncrement();
        } else {
            this.hitCount.getAndIncrement();
        }
        return (V)value;
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<K> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K key : keys) {
            V value = this.getIfPresent(key);
            if (value == null) continue;
            builder.put(key, value);
        }
        return builder.build();
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        K k = key;
        synchronized (k) {
            Object value = this.cache.get(key);
            if (value != null) {
                return (V)value;
            }
            try {
                value = valueLoader.call();
                this.cache.put(key, value);
                return (V)value;
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "got an exception while loading key [%s]", new Object[]{key});
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public void invalidate(K key) {
        this.cache.remove(key);
    }

    @Override
    public void invalidateAll(Iterable<K> keys) {
        for (K key : keys) {
            this.invalidate(key);
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.clear();
    }

    @Override
    public LookupCacheStats getStats() {
        return new LookupCacheStats(this.hitCount.get(), this.missCount.get(), this.evictionCount.get());
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            DB.delete(String.valueOf(this.name));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffHeapLoadingCache)) {
            return false;
        }
        OffHeapLoadingCache that = (OffHeapLoadingCache)o;
        if (Double.compare(that.maxStoreSize, this.maxStoreSize) != 0) {
            return false;
        }
        if (this.maxEntriesSize != that.maxEntriesSize) {
            return false;
        }
        if (this.expireAfterWrite != that.expireAfterWrite) {
            return false;
        }
        return this.expireAfterAccess == that.expireAfterAccess;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.maxStoreSize);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.maxEntriesSize ^ this.maxEntriesSize >>> 32);
        result = 31 * result + (int)(this.expireAfterWrite ^ this.expireAfterWrite >>> 32);
        result = 31 * result + (int)(this.expireAfterAccess ^ this.expireAfterAccess >>> 32);
        return result;
    }
}

