/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache.loading;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.lookup.cache.loading.LoadingCache;
import io.druid.server.lookup.cache.loading.LookupCacheStats;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class OnHeapLoadingCache<K, V>
implements LoadingCache<K, V> {
    private static final Logger log = new Logger(OnHeapLoadingCache.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private final Cache<K, V> cache;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    @JsonProperty
    private final int concurrencyLevel;
    @JsonProperty
    private final int initialCapacity;
    @JsonProperty
    private final Long maximumSize;
    @JsonProperty
    private final Long expireAfterAccess;
    @JsonProperty
    private final Long expireAfterWrite;

    @JsonCreator
    public OnHeapLoadingCache(@JsonProperty(value="concurrencyLevel") int concurrencyLevel, @JsonProperty(value="initialCapacity") int initialCapacity, @JsonProperty(value="maximumSize") Long maximumSize, @JsonProperty(value="expireAfterAccess") Long expireAfterAccess, @JsonProperty(value="expireAfterWrite") Long expireAfterWrite) {
        this.concurrencyLevel = concurrencyLevel <= 0 ? 4 : concurrencyLevel;
        this.initialCapacity = initialCapacity <= 0 ? 16 : initialCapacity;
        this.maximumSize = maximumSize;
        this.expireAfterAccess = expireAfterAccess;
        this.expireAfterWrite = expireAfterWrite;
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(this.concurrencyLevel).initialCapacity(this.initialCapacity).recordStats();
        if (this.expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.expireAfterWrite != null) {
            builder.expireAfterWrite(this.expireAfterWrite.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize.longValue());
        }
        this.cache = builder.build();
        if (this.isClosed.getAndSet(false)) {
            log.info("Guava Based OnHeapCache started with spec [%s]", new Object[]{this.cache.toString()});
        }
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<K> keys) {
        return this.cache.getAllPresent(keys);
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        return (V)this.cache.get(key, valueLoader);
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll(Iterable<K> keys) {
        this.cache.invalidateAll(keys);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public LookupCacheStats getStats() {
        return new LookupCacheStats(this.cache.stats().hitCount(), this.cache.stats().missCount(), this.cache.stats().evictionCount());
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            this.cache.cleanUp();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OnHeapLoadingCache)) {
            return false;
        }
        OnHeapLoadingCache that = (OnHeapLoadingCache)o;
        if (this.concurrencyLevel != that.concurrencyLevel) {
            return false;
        }
        if (this.initialCapacity != that.initialCapacity) {
            return false;
        }
        if (this.maximumSize != null ? !this.maximumSize.equals(that.maximumSize) : that.maximumSize != null) {
            return false;
        }
        if (this.expireAfterAccess != null ? !this.expireAfterAccess.equals(that.expireAfterAccess) : that.expireAfterAccess != null) {
            return false;
        }
        return this.expireAfterWrite != null ? this.expireAfterWrite.equals(that.expireAfterWrite) : that.expireAfterWrite == null;
    }

    public int hashCode() {
        int result = this.concurrencyLevel;
        result = 31 * result + this.initialCapacity;
        result = 31 * result + (this.maximumSize != null ? this.maximumSize.hashCode() : 0);
        result = 31 * result + (this.expireAfterAccess != null ? this.expireAfterAccess.hashCode() : 0);
        result = 31 * result + (this.expireAfterWrite != null ? this.expireAfterWrite.hashCode() : 0);
        return result;
    }
}

