/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache.polling;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.java.util.common.StringUtils;
import io.druid.server.lookup.cache.polling.PollingCache;
import io.druid.server.lookup.cache.polling.PollingCacheFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class OffHeapPollingCache<K, V>
implements PollingCache<K, V> {
    private static final DB DB = DBMaker.newMemoryDirectDB().transactionDisable().closeOnJvmShutdown().make();
    private final HTreeMap<K, V> mapCache;
    private final HTreeMap<V, List<K>> reverseCache;
    private final AtomicBoolean started;
    private final String cacheName;
    private final String reverseCacheName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapPollingCache(Iterable<Map.Entry<K, V>> entries) {
        AtomicBoolean atomicBoolean = this.started = new AtomicBoolean(false);
        synchronized (atomicBoolean) {
            this.cacheName = StringUtils.format((String)"cache-%s", (Object[])new Object[]{UUID.randomUUID()});
            this.reverseCacheName = StringUtils.format((String)"reverseCache-%s", (Object[])new Object[]{UUID.randomUUID()});
            this.mapCache = DB.createHashMap(this.cacheName).make();
            this.reverseCache = DB.createHashMap(this.reverseCacheName).make();
            ImmutableSet.Builder setOfValuesBuilder = ImmutableSet.builder();
            for (Map.Entry<K, V> entry : entries) {
                this.mapCache.put(entry.getKey(), entry.getValue());
                setOfValuesBuilder.add(entry.getValue());
            }
            ImmutableSet setOfValues = setOfValuesBuilder.build();
            this.reverseCache.putAll(Maps.asMap((Set)setOfValues, (Function)new Function<V, List<K>>(){

                public List<K> apply(final V input) {
                    return Lists.newArrayList(Maps.filterKeys((Map)OffHeapPollingCache.this.mapCache, (Predicate)new Predicate<K>(){

                        public boolean apply(K key) {
                            Object retVal = OffHeapPollingCache.this.mapCache.get(key);
                            if (retVal == null) {
                                return false;
                            }
                            return retVal.equals(input);
                        }
                    }).keySet());
                }
            }));
            this.started.getAndSet(true);
        }
    }

    @Override
    public V get(K key) {
        return (V)this.mapCache.get(key);
    }

    @Override
    public List<K> getKeys(V value) {
        List listOfKey = (List)this.reverseCache.get(value);
        if (listOfKey == null) {
            return Collections.emptyList();
        }
        return listOfKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                DB.delete(this.cacheName);
                DB.delete(this.reverseCacheName);
            }
        }
    }

    public static class OffHeapPollingCacheProvider<K, V>
    implements PollingCacheFactory<K, V> {
        @Override
        public PollingCache<K, V> makeOf(Iterable<Map.Entry<K, V>> entries) {
            return new OffHeapPollingCache<K, V>(entries);
        }
    }
}

