/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache.polling;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.server.lookup.cache.polling.PollingCache;
import io.druid.server.lookup.cache.polling.PollingCacheFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OnHeapPollingCache<K, V>
implements PollingCache<K, V> {
    private final ImmutableMap<K, V> immutableMap;
    private final ImmutableMap<V, List<K>> immutableReverseMap;

    public OnHeapPollingCache(Iterable<Map.Entry<K, V>> entries) {
        if (entries == null) {
            this.immutableMap = ImmutableMap.of();
            this.immutableReverseMap = ImmutableMap.of();
        } else {
            ImmutableSet.Builder setOfValuesBuilder = ImmutableSet.builder();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (Map.Entry<K, V> entry : entries) {
                setOfValuesBuilder.add(entry.getValue());
                mapBuilder.put(entry.getKey(), entry.getValue());
            }
            ImmutableSet setOfValues = setOfValuesBuilder.build();
            this.immutableMap = mapBuilder.build();
            this.immutableReverseMap = ImmutableMap.copyOf((Map)Maps.asMap((Set)setOfValues, (Function)new Function<V, List<K>>(){

                public List<K> apply(final V input) {
                    return Lists.newArrayList(Maps.filterKeys((Map)OnHeapPollingCache.this.immutableMap, (Predicate)new Predicate<K>(){

                        public boolean apply(K key) {
                            Object retVal = OnHeapPollingCache.this.immutableMap.get(key);
                            if (retVal == null) {
                                return false;
                            }
                            return retVal.equals(input);
                        }
                    }).keySet());
                }
            }));
        }
    }

    @Override
    public V get(K key) {
        return (V)this.immutableMap.get(key);
    }

    @Override
    public List<K> getKeys(V value) {
        List listOfKeys = (List)this.immutableReverseMap.get(value);
        if (listOfKeys == null) {
            return Collections.emptyList();
        }
        return listOfKeys;
    }

    @Override
    public void close() {
    }

    public static class OnHeapPollingCacheProvider<K, V>
    implements PollingCacheFactory<K, V> {
        @Override
        public PollingCache makeOf(Iterable<Map.Entry<K, V>> entries) {
            return new OnHeapPollingCache<K, V>(entries);
        }
    }
}

