/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.jdbc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.server.lookup.DataFetcher;
import io.druid.server.lookup.jdbc.KeyValueResultSetMapper;
import io.druid.server.lookup.jdbc.QueryKeys;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class JdbcDataFetcher
implements DataFetcher<String, String> {
    private static final Logger LOGGER = new Logger(JdbcDataFetcher.class);
    private static final int DEFAULT_STREAMING_FETCH_SIZE = 1000;
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    @JsonProperty
    private final String table;
    @JsonProperty
    private final String keyColumn;
    @JsonProperty
    private final String valueColumn;
    @JsonProperty
    private final int streamingFetchSize;
    private final String fetchAllQuery;
    private final String fetchQuery;
    private final String reverseFetchQuery;
    private final DBI dbi;

    public JdbcDataFetcher(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig connectorConfig, @JsonProperty(value="table") String table, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn, @JsonProperty(value="streamingFetchSize") Integer streamingFetchSize) {
        this.connectorConfig = (MetadataStorageConnectorConfig)Preconditions.checkNotNull((Object)connectorConfig, (Object)"connectorConfig");
        this.streamingFetchSize = streamingFetchSize == null ? 1000 : streamingFetchSize;
        Preconditions.checkNotNull((Object)connectorConfig.getConnectURI(), (Object)"connectorConfig.connectURI");
        this.table = (String)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.keyColumn = (String)Preconditions.checkNotNull((Object)keyColumn, (Object)"keyColumn");
        this.valueColumn = (String)Preconditions.checkNotNull((Object)valueColumn, (Object)"valueColumn");
        this.fetchAllQuery = StringUtils.format((String)"SELECT %s, %s FROM %s", (Object[])new Object[]{this.keyColumn, this.valueColumn, this.table});
        this.fetchQuery = StringUtils.format((String)"SELECT %s FROM %s WHERE %s = :val", (Object[])new Object[]{this.valueColumn, this.table, this.keyColumn});
        this.reverseFetchQuery = StringUtils.format((String)"SELECT %s FROM %s WHERE %s = :val", (Object[])new Object[]{this.keyColumn, this.table, this.valueColumn});
        this.dbi = new DBI(connectorConfig.getConnectURI(), connectorConfig.getUser(), connectorConfig.getPassword());
        this.dbi.registerMapper((ResultSetMapper)new KeyValueResultSetMapper(keyColumn, valueColumn));
    }

    @Override
    public Iterable<Map.Entry<String, String>> fetchAll() {
        return (Iterable)this.inReadOnlyTransaction((handle, status) -> handle.createQuery(this.fetchAllQuery).setFetchSize(this.streamingFetchSize).map((ResultSetMapper)new KeyValueResultSetMapper(this.keyColumn, this.valueColumn)).list());
    }

    @Override
    public String fetch(final String key) {
        List<String> pairs = this.inReadOnlyTransaction(new TransactionCallback<List<String>>(){

            public List<String> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                return ((Query)handle.createQuery(JdbcDataFetcher.this.fetchQuery).bind("val", key)).map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
        if (pairs.isEmpty()) {
            return null;
        }
        return Strings.nullToEmpty((String)pairs.get(0));
    }

    @Override
    public Iterable<Map.Entry<String, String>> fetch(Iterable<String> keys) {
        QueryKeys queryKeys = (QueryKeys)this.dbi.onDemand(QueryKeys.class);
        return queryKeys.findNamesForIds(Lists.newArrayList(keys), this.table, this.keyColumn, this.valueColumn);
    }

    @Override
    public List<String> reverseFetchKeys(final String value) {
        List<String> results = this.inReadOnlyTransaction(new TransactionCallback<List<String>>(){

            public List<String> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                return ((Query)handle.createQuery(JdbcDataFetcher.this.reverseFetchQuery).bind("val", value)).map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDataFetcher)) {
            return false;
        }
        JdbcDataFetcher that = (JdbcDataFetcher)o;
        if (!this.connectorConfig.equals((Object)that.connectorConfig)) {
            return false;
        }
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.keyColumn.equals(that.keyColumn)) {
            return false;
        }
        return this.valueColumn.equals(that.valueColumn);
    }

    public String toString() {
        return "JdbcDataFetcher{table='" + this.table + '\'' + ", keyColumn='" + this.keyColumn + '\'' + ", valueColumn='" + this.valueColumn + '\'' + '}';
    }

    private DBI getDbi() {
        return this.dbi;
    }

    private <T> T inReadOnlyTransaction(final TransactionCallback<T> callback) {
        return (T)this.getDbi().withHandle(new HandleCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T withHandle(Handle handle) throws Exception {
                Connection connection = handle.getConnection();
                boolean readOnly = connection.isReadOnly();
                connection.setReadOnly(true);
                try {
                    Object object = handle.inTransaction(callback);
                    return object;
                }
                finally {
                    try {
                        connection.setReadOnly(readOnly);
                    }
                    catch (SQLException e) {
                        LOGGER.error((Throwable)e, "Unable to reset connection read-only state", new Object[0]);
                    }
                }
            }
        });
    }
}

