/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.jdbc;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterContainerMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.unstable.BindIn;

@UseStringTemplate3StatementLocator
@RegisterContainerMapper(value={QueryKeysContainerFactory.class})
public interface QueryKeys {
    @SqlQuery(value="SELECT <keyColumn>, <valueColumn> FROM <table> WHERE <keyColumn> IN (<keys>)")
    public ImmutableSet<Map.Entry<String, String>> findNamesForIds(@BindIn(value="keys") List<String> var1, @Define(value="table") String var2, @Define(value="keyColumn") String var3, @Define(value="valueColumn") String var4);

    public static class QueryKeysContainerFactory
    implements ContainerFactory<ImmutableSet<?>> {
        public boolean accepts(Class<?> type) {
            return ImmutableSet.class.isAssignableFrom(type);
        }

        public ContainerBuilder<ImmutableSet<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<ImmutableSet<?>>(){
                final ImmutableSet.Builder<Object> builder = new ImmutableSet.Builder();

                public ContainerBuilder<ImmutableSet<?>> add(Object obj) {
                    this.builder.add(obj);
                    return this;
                }

                public ImmutableSet<?> build() {
                    return this.builder.build();
                }
            };
        }
    }
}

