/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.common.collect.ImmutableList;
import io.druid.data.input.ByteBufferInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.ParseSpec;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.java.util.common.parsers.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.Descriptors;
import shaded.com.google.protobuf.DynamicMessage;
import shaded.com.google.protobuf.InvalidProtocolBufferException;
import shaded.com.google.protobuf.util.JsonFormat;

public class ProtobufInputRowParser
implements ByteBufferInputRowParser {
    private final ParseSpec parseSpec;
    private final String descriptorFilePath;
    private final String protoMessageType;
    private final Descriptors.Descriptor descriptor;
    private Parser<String, Object> parser;

    @JsonCreator
    public ProtobufInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="descriptor") String descriptorFilePath, @JsonProperty(value="protoMessageType") String protoMessageType) {
        this.parseSpec = parseSpec;
        this.descriptorFilePath = descriptorFilePath;
        this.protoMessageType = protoMessageType;
        this.descriptor = this.getDescriptor(descriptorFilePath);
    }

    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public ProtobufInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new ProtobufInputRowParser(parseSpec, this.descriptorFilePath, this.protoMessageType);
    }

    public List<InputRow> parseBatch(ByteBuffer input) {
        String json;
        if (this.parser == null) {
            this.parser = this.parseSpec.makeParser();
        }
        try {
            DynamicMessage message = DynamicMessage.parseFrom(this.descriptor, ByteString.copyFrom(input));
            json = JsonFormat.printer().print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ParseException((Throwable)e, "Protobuf message could not be parsed", new Object[0]);
        }
        Map record = this.parser.parseToMap(json);
        return ImmutableList.of(new MapBasedInputRow(this.parseSpec.getTimestampSpec().extractTimestamp(record), this.parseSpec.getDimensionsSpec().getDimensionNames(), record));
    }

    private Descriptors.Descriptor getDescriptor(String descriptorFilePath) {
        InputStream fin = this.getClass().getClassLoader().getResourceAsStream(descriptorFilePath);
        if (fin == null) {
            URL url = null;
            try {
                url = new URL(descriptorFilePath);
            }
            catch (MalformedURLException e) {
                throw new ParseException((Throwable)e, "Descriptor not found in class path or malformed URL:" + descriptorFilePath, new Object[0]);
            }
            try {
                fin = url.openConnection().getInputStream();
            }
            catch (IOException e) {
                throw new ParseException((Throwable)e, "Cannot read descriptor file: " + url.toString(), new Object[0]);
            }
        }
        DynamicSchema dynamicSchema = null;
        try {
            dynamicSchema = DynamicSchema.parseFrom(fin);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new ParseException((Throwable)e, "Invalid descriptor file: " + descriptorFilePath, new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e, "Cannot read descriptor file: " + descriptorFilePath, new Object[0]);
        }
        Set<String> messageTypes = dynamicSchema.getMessageTypes();
        if (messageTypes.size() == 0) {
            throw new ParseException("No message types found in the descriptor: " + descriptorFilePath, new Object[0]);
        }
        String messageType = this.protoMessageType == null ? (String)messageTypes.toArray()[0] : this.protoMessageType;
        Descriptors.Descriptor desc = dynamicSchema.getMessageDescriptor(messageType);
        if (desc == null) {
            throw new ParseException(StringUtils.format((String)"Protobuf message type %s not found in the specified descriptor.  Available messages types are %s", (Object[])new Object[]{this.protoMessageType, messageTypes}), new Object[0]);
        }
        return desc;
    }
}

