/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.s3.S3DataSegmentArchiverConfig;
import io.druid.storage.s3.S3DataSegmentMover;
import io.druid.storage.s3.S3DataSegmentPusherConfig;
import io.druid.timeline.DataSegment;
import java.util.Map;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;

public class S3DataSegmentArchiver
extends S3DataSegmentMover
implements DataSegmentArchiver {
    private final S3DataSegmentArchiverConfig archiveConfig;
    private final S3DataSegmentPusherConfig restoreConfig;

    @Inject
    public S3DataSegmentArchiver(RestS3Service s3Client, S3DataSegmentArchiverConfig archiveConfig, S3DataSegmentPusherConfig restoreConfig) {
        super(s3Client, restoreConfig);
        this.archiveConfig = archiveConfig;
        this.restoreConfig = restoreConfig;
    }

    public DataSegment archive(DataSegment segment) throws SegmentLoadingException {
        String targetS3Bucket = this.archiveConfig.getArchiveBucket();
        String targetS3BaseKey = this.archiveConfig.getArchiveBaseKey();
        return this.move(segment, (Map<String, Object>)ImmutableMap.of((Object)"bucket", (Object)targetS3Bucket, (Object)"baseKey", (Object)targetS3BaseKey));
    }

    public DataSegment restore(DataSegment segment) throws SegmentLoadingException {
        String targetS3Bucket = this.restoreConfig.getBucket();
        String targetS3BaseKey = this.restoreConfig.getBaseKey();
        return this.move(segment, (Map<String, Object>)ImmutableMap.of((Object)"bucket", (Object)targetS3Bucket, (Object)"baseKey", (Object)targetS3BaseKey));
    }
}

