/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.s3.S3Utils;
import io.druid.timeline.DataSegment;
import java.util.Map;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;

public class S3DataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(S3DataSegmentKiller.class);
    private final RestS3Service s3Client;

    @Inject
    public S3DataSegmentKiller(RestS3Service s3Client) {
        this.s3Client = s3Client;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        try {
            Map loadSpec = segment.getLoadSpec();
            String s3Bucket = MapUtils.getString((Map)loadSpec, (String)"bucket");
            String s3Path = MapUtils.getString((Map)loadSpec, (String)"key");
            String s3DescriptorPath = S3Utils.descriptorPathForSegmentPath(s3Path);
            if (this.s3Client.isObjectInBucket(s3Bucket, s3Path)) {
                log.info("Removing index file[s3://%s/%s] from s3!", new Object[]{s3Bucket, s3Path});
                this.s3Client.deleteObject(s3Bucket, s3Path);
            }
            if (this.s3Client.isObjectInBucket(s3Bucket, s3DescriptorPath)) {
                log.info("Removing descriptor file[s3://%s/%s] from s3!", new Object[]{s3Bucket, s3DescriptorPath});
                this.s3Client.deleteObject(s3Bucket, s3DescriptorPath);
            }
        }
        catch (ServiceException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getIdentifier(), e});
        }
    }
}

