/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.MapUtils;
import com.metamx.common.StringUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.storage.s3.S3DataSegmentPusherConfig;
import io.druid.storage.s3.S3Utils;
import io.druid.timeline.DataSegment;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3DataSegmentMover
implements DataSegmentMover {
    private static final Logger log = new Logger(S3DataSegmentMover.class);
    private final RestS3Service s3Client;
    private final S3DataSegmentPusherConfig config;

    @Inject
    public S3DataSegmentMover(RestS3Service s3Client, S3DataSegmentPusherConfig config) {
        this.s3Client = s3Client;
        this.config = config;
    }

    public DataSegment move(DataSegment segment, Map<String, Object> targetLoadSpec) throws SegmentLoadingException {
        try {
            Map loadSpec = segment.getLoadSpec();
            String s3Bucket = MapUtils.getString((Map)loadSpec, (String)"bucket");
            String s3Path = MapUtils.getString((Map)loadSpec, (String)"key");
            String s3DescriptorPath = S3Utils.descriptorPathForSegmentPath(s3Path);
            String targetS3Bucket = MapUtils.getString(targetLoadSpec, (String)"bucket");
            String targetS3BaseKey = MapUtils.getString(targetLoadSpec, (String)"baseKey");
            String targetS3Path = S3Utils.constructSegmentPath(targetS3BaseKey, segment);
            String targetS3DescriptorPath = S3Utils.descriptorPathForSegmentPath(targetS3Path);
            if (targetS3Bucket.isEmpty()) {
                throw new SegmentLoadingException("Target S3 bucket is not specified", new Object[0]);
            }
            if (targetS3Path.isEmpty()) {
                throw new SegmentLoadingException("Target S3 baseKey is not specified", new Object[0]);
            }
            this.safeMove(s3Bucket, s3Path, targetS3Bucket, targetS3Path);
            this.safeMove(s3Bucket, s3DescriptorPath, targetS3Bucket, targetS3DescriptorPath);
            return segment.withLoadSpec((Map)ImmutableMap.builder().putAll(Maps.filterKeys((Map)loadSpec, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !input.equals("bucket") && !input.equals("key");
                }
            })).put((Object)"bucket", (Object)targetS3Bucket).put((Object)"key", (Object)targetS3Path).build());
        }
        catch (ServiceException e) {
            throw new SegmentLoadingException((Throwable)e, "Unable to move segment[%s]: [%s]", new Object[]{segment.getIdentifier(), e});
        }
    }

    private void safeMove(final String s3Bucket, final String s3Path, final String targetS3Bucket, final String targetS3Path) throws ServiceException, SegmentLoadingException {
        try {
            S3Utils.retryS3Operation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (s3Bucket.equals(targetS3Bucket) && s3Path.equals(targetS3Path)) {
                        log.info("No need to move file[s3://%s/%s] onto itself", new Object[]{s3Bucket, s3Path});
                        return null;
                    }
                    if (S3DataSegmentMover.this.s3Client.isObjectInBucket(s3Bucket, s3Path)) {
                        S3Object[] list = S3DataSegmentMover.this.s3Client.listObjects(s3Bucket, s3Path, "");
                        if (list.length == 0) {
                            throw new ISE("Unable to list object [s3://%s/%s]", new Object[]{s3Bucket, s3Path});
                        }
                        S3Object s3Object = list[0];
                        if (s3Object.getStorageClass() != null && s3Object.getStorageClass().equals("GLACIER")) {
                            log.warn("Cannot move file[s3://%s/%s] of storage class glacier, skipping.", new Object[]{s3Bucket, s3Path});
                        } else {
                            Map copyResult;
                            String copyMsg = StringUtils.safeFormat((String)"[s3://%s/%s] to [s3://%s/%s]", (Object[])new Object[]{s3Bucket, s3Path, targetS3Bucket, targetS3Path});
                            log.info("Moving file %s", new Object[]{copyMsg});
                            S3Object target = new S3Object(targetS3Path);
                            if (!S3DataSegmentMover.this.config.getDisableAcl()) {
                                target.setAcl((AccessControlList)GSAccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL);
                            }
                            if ((copyResult = S3DataSegmentMover.this.s3Client.moveObject(s3Bucket, s3Path, targetS3Bucket, (StorageObject)target, false)) != null && copyResult.containsKey("DeleteException")) {
                                log.error("Error Deleting data after copy %s: %s", new Object[]{copyMsg, copyResult});
                            } else {
                                log.debug("Finished moving file %s", new Object[]{copyMsg});
                            }
                        }
                    } else if (S3DataSegmentMover.this.s3Client.isObjectInBucket(targetS3Bucket, targetS3Path)) {
                        log.info("Not moving file [s3://%s/%s], already present in target location [s3://%s/%s]", new Object[]{s3Bucket, s3Path, targetS3Bucket, targetS3Path});
                    } else {
                        throw new SegmentLoadingException("Unable to move file [s3://%s/%s] to [s3://%s/%s], not present in either source or target location", new Object[]{s3Bucket, s3Path, targetS3Bucket, targetS3Path});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, ServiceException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, SegmentLoadingException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

